#include "View.h"


View::View(Model* m, Controller* c, QWidget* parent) : QMainWindow(parent), ui(new ViewWindow()), model(m), controller(c) {
    model->addObserver(this);
    ui->setupUi(this);
    update();
}

View::~View() {
    model->removeObserver(this);
    delete ui;
}

void View::update() {
    int value = model->getData();
    ui->textCtrl->setText(QString::number(value));
}

void View::onIncrementButton() {
    controller->increment();
}

void View::onDecrementButton() {
    controller->decrement();
}

