#ifndef QTMVCEXAMPLE_VIEWWINDOW_H
#define QTMVCEXAMPLE_VIEWWINDOW_H

#include <QtCore/QVariant>
#include <QtWidgets/QAction>
#include <QtWidgets/QApplication>
#include <QtWidgets/QButtonGroup>
#include <QtWidgets/QHeaderView>
#include <QtWidgets/QLabel>
#include <QtWidgets/QMainWindow>
#include <QtWidgets/QPushButton>
#include <QtWidgets/QTextEdit>
#include <QtWidgets/QWidget>
#include <QtWidgets/QLineEdit>


QT_BEGIN_NAMESPACE

class ViewWindow {
public:
    QWidget *ViewWidget;
    QPushButton *incrementButton;
    QPushButton *decrementButton;
    QLabel *staticText;
    QLineEdit *textCtrl;

    void setupUi(QMainWindow *View) {
        if (View->objectName().isEmpty())
            View->setObjectName(QStringLiteral("ViewWindow"));
        View->resize(400, 300);
        ViewWidget = new QWidget(View);
        ViewWidget->setObjectName(QStringLiteral("ViewWindow"));
        incrementButton = new QPushButton(ViewWidget);
        incrementButton->setObjectName(QStringLiteral("incrementButton"));
        incrementButton->setGeometry(QRect(200, 50, 113, 32));
        decrementButton = new QPushButton(ViewWidget);
        decrementButton->setObjectName(QStringLiteral("decrementButton"));
        decrementButton->setGeometry(QRect(200, 90, 113, 32));
        staticText = new QLabel(ViewWidget);
        staticText->setObjectName(QStringLiteral("staticText"));
        staticText->setGeometry(QRect(20, 60, 60, 21));
        textCtrl = new QLineEdit(ViewWidget);
        textCtrl->setObjectName(QStringLiteral("textCtrl"));
        textCtrl->setGeometry(QRect(70, 60, 104, 21));
        textCtrl->setAlignment(Qt::AlignRight);
        View->setCentralWidget(ViewWidget);

        retranslateUi(View);
        QObject::connect(incrementButton, SIGNAL(clicked()), View, SLOT(onIncrementButton()));
        QObject::connect(decrementButton, SIGNAL(clicked()), View, SLOT(onDecrementButton()));

        QMetaObject::connectSlotsByName(View);
    } // setupUi

    void retranslateUi(QMainWindow *View) {
        View->setWindowTitle(QApplication::translate("ViewWindow", "MVC Example", nullptr));
        incrementButton->setText(QApplication::translate("ViewWindow", "Increment", nullptr));
        decrementButton->setText(QApplication::translate("ViewWindow", "Decrement", nullptr));
        staticText->setText(QApplication::translate("ViewWindow", "Value", nullptr));
    } // retranslateUi

};

QT_END_NAMESPACE


#endif //QTMVCEXAMPLE_VIEWWINDOW_H
