#ifndef TEXTMVCEXAMPLE_MODEL_H
#define TEXTMVCEXAMPLE_MODEL_H

#include <list>
#include "Subject.h"

class Model : public Subject {
public:
    int getData(){
        return data;
    }
    void setData(const int i) {
        data = i;
        notify();
    }
    virtual void addObserver(Observer* o) {
        observers.push_back(o);
    }
    virtual void removeObserver(Observer* o) {
        observers.remove(o);
    }
    virtual void notify() {
        for (Observer* observer : observers)
            observer->update();
    }
private:
    int data = 0; // C++11 initialization of data member
    std::list<Observer*> observers;
};

#endif //TEXTMVCEXAMPLE_MODEL_H
