#ifndef TEXTMVCEXAMPLE_VIEW_H
#define TEXTMVCEXAMPLE_VIEW_H

#include "Model.h"
#include "Controller.h"
#include <iostream>

class View : public Observer {
public:
    View(Model* m, Controller* c) {
        model = m;
        model->addObserver(this);
        controller = c;
    }
    virtual ~View() { model->removeObserver(this); }
    void displayTextField(int i) {
        std::cout << "Text field: " << i << std::endl;
    }
    virtual void update() {
        int value = model->getData();
        displayTextField(value);
    }
    void incrementButton() {
        controller->increment();
    }
    void decrementButton() {
        controller->decrement();
    }
private:
    Model* model;
    Controller* controller;
};

#endif //TEXTMVCEXAMPLE_VIEW_H
