#include "MiniMapView.h"

MiniMapView::MiniMapView(GameCharacter* h, const std::string& bitmapName, wxWindow* parent, wxWindowID id, const wxString &title, const wxPoint &pos,
                                   const wxSize &size, long style) : wxFrame( parent, id, title, pos, size, style ) {
    gameMapImage.LoadFile(bitmapName, wxBITMAP_TYPE_JPEG);
    wxSize imageSize(gameMapImage.GetWidth(), gameMapImage.GetHeight());

    this->SetSize(imageSize);
    this->SetSizeHints( imageSize, imageSize );
    sizer = new wxBoxSizer(wxHORIZONTAL);
    this->SetSizer(sizer);
    drawPane = new wxPanel( this );
    sizer->Add(drawPane, 1, wxEXPAND);
    this->SetAutoLayout(true);

    // Connect Events
    this->Connect( wxEVT_PAINT, wxPaintEventHandler( MiniMapView::OnPaint ) );

    // TODO update data
}

MiniMapView::~MiniMapView() {
    // Disconnect Events
    this->Disconnect( wxEVT_PAINT, wxPaintEventHandler( MiniMapView::OnPaint ) );
}

// event to paint the bitmap panel when the miniMap requires to repaint
void MiniMapView::OnPaint(wxPaintEvent &event) {
    // Do not store the created DC or keep it for later in any way.
#ifdef __LINUX__
    wxPaintDC dc(drawPane);
#else
    wxClientDC dc(this);
#endif
    render(dc);
}

// paint the bitmap panel when requested
void MiniMapView::draw() {
    // Do not store the created DC or keep it for later in any way.
#ifdef __LINUX__
    wxClientDC dc(drawPane);
#else
    wxClientDC dc(this);
#endif
    render(dc);
}

// method actually drawing in the pane
void MiniMapView::render(wxDC &dc) {
    if(gameMapImage.Ok()) {
        dc.DrawBitmap(gameMapImage, 0, 0);
    }
    // draw a circle
    dc.SetBrush(*wxRED_BRUSH); // red filling
    dc.SetPen( wxPen( wxColor(255,255,255), 2 ) ); // 2-pixels-thick white outline
    int miniPosX = posX / 4 + 180;
    int miniPosY = posY / 4;
    int miniRadius = posRadius / 4;
    dc.DrawCircle( wxPoint(miniPosX, miniPosY), miniRadius /* radius */ );
}

