#include <iostream>

#include <wx/wxprec.h>
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "VideogameMapView.h"
#include "GameCharacter.h"
#include "MiniMapView.h"

// XXX some Windows user may need to uncomment the following define
//#define __GXX_ABI_VERSION 1011

class GameApp: public wxApp {
public:
    virtual bool OnInit();
    virtual int FilterEvent(wxEvent& event);

private:
    VideogameMapView* mainMap;
    MiniMapView* miniMap;
    GameCharacter* hero;
    bool isMinimapOpen;

    void OpenCloseMinimap();
};

wxIMPLEMENT_APP(GameApp);

bool GameApp::OnInit() {
    wxImageHandler* jpegLoader = new wxJPEGHandler();
    wxImage::AddHandler(jpegLoader);

    hero = new GameCharacter;
    mainMap = new VideogameMapView(hero, "./res/large_map.jpg");
    miniMap = new MiniMapView(hero, "./res/mini_map.jpg", mainMap);

    mainMap->update();
    miniMap->update();

    mainMap->Show( true );
    miniMap->Show( true );
    isMinimapOpen = true;
    return true;
}

int GameApp::FilterEvent(wxEvent& event) {
    const int step = 4;
    if (event.GetEventType() == wxEVT_ENTER_WINDOW){
        mainMap->draw();
        miniMap->draw();
    }
    
    if (event.GetEventType() == wxEVT_KEY_DOWN) {
        wxChar uc = ((wxKeyEvent&)event).GetUnicodeKey();
        if(uc>=32) {
            switch (uc) {
                case 'Q':
                    Exit();
                case 'W':
                    // graphics coordinates: (0,0) is top-left
                    hero->move(0, -step);
                    break;
                case 'A':
                    hero->move(-step, 0);
                    break;
                case 'S':
                    // graphics coordinates: (0,0) is top-left
                    hero->move(0, step);
                    break;
                case 'D':
                    hero->move(step, 0);
                    break;
                case 'M':
                    OpenCloseMinimap();
                    break;
                default:
                    std::cout << "Press: w,a,s,d (to move), m (show/close minimap) or Q to quit." << std::endl;
                    break;
            }
        }
        return true;
    }
    return -1;
}

void GameApp::OpenCloseMinimap() {
    if (isMinimapOpen) {
        isMinimapOpen = false;
    } else {
        isMinimapOpen = true;
        // TODO refresh minimap view
    }
    miniMap->Show( isMinimapOpen );
}






