#include "VideogameMapView.h"

VideogameMapView::VideogameMapView(GameCharacter* h, const std::string& bitmapName, wxWindow* parent, wxWindowID id, const wxString &title, const wxPoint &pos,
                                   const wxSize &size, long style) : wxFrame( parent, id, title, pos, size, style ) {
    gameMapImage.LoadFile(bitmapName, wxBITMAP_TYPE_JPEG);
    wxSize imageSize(gameMapImage.GetWidth(), gameMapImage.GetHeight());

    this->SetSize(imageSize);
    this->SetSizeHints( imageSize, imageSize );
    sizer = new wxBoxSizer(wxHORIZONTAL);
    this->SetSizer(sizer);
    drawPane = new wxPanel( this );
    sizer->Add(drawPane, 1, wxEXPAND);
    this->SetAutoLayout(true);

    // Connect Events
    this->Connect( wxEVT_PAINT, wxPaintEventHandler( VideogameMapView::OnPaint ) );

    renderHUD();
    // TODO update data
}

VideogameMapView::~VideogameMapView() {
    // Disconnect Events
    this->Disconnect( wxEVT_PAINT, wxPaintEventHandler( VideogameMapView::OnPaint ) );
}

// render Head Up Display
void VideogameMapView::renderHUD() {
    std::cout << "Press: w,a,s,d (to move), m (show/close minimap) or Q to quit." << std::endl;
}

// event to paint the bitmap panel when the mainMap requires to repaint
void VideogameMapView::OnPaint(wxPaintEvent &event) {
    // Do not store the created DC or keep it for later in any way.
#ifdef __LINUX__
    wxPaintDC dc(drawPane);
#else
    wxClientDC dc(this);
#endif
    render(dc);
}

// paint the bitmap panel when requested
void VideogameMapView::draw() {
    // Do not store the created DC or keep it for later in any way.
#ifdef __LINUX__
    wxClientDC dc(drawPane);
#else
    wxClientDC dc(this);
#endif
    render(dc);
}

// method actually drawing in the pane
void VideogameMapView::render(wxDC &dc) {
    if(gameMapImage.Ok()) {
        dc.DrawBitmap(gameMapImage, 0, 0);
    }
    // draw a circle
    dc.SetBrush(*wxRED_BRUSH); // red filling
    dc.SetPen( wxPen( wxColor(255,255,255), 2 ) ); // 2-pixels-thick white outline
    dc.DrawCircle( wxPoint(posX, posY), posRadius /* radius */ );
}


