#include <algorithm>
#include <list>
#include <iostream>

struct DiskFile {
    DiskFile(std::string n = "", float fs = 0. ) : name (n), fileSize(fs) {}

    bool operator==(const DiskFile &right) const {
        if ((name == right.name) && (fileSize == right.fileSize))
            return true;
        else
            return false;
    }

    std::string name;
    float fileSize; // size in MB
};

class Filesystem {
public:
    Filesystem(float size) : freeSize(size), diskSize(size) {};

    int getNumFiles() {}; // TODO implement and make it safer
    float getFreeSpace() {}; // TODO implement and make it safer
    float getOccupiedSpace() {}; // TODO implement and make it safer
    void create(DiskFile newFile) {};  // TODO implement add file
                                    // at the end of list
    void remove(DiskFile oldFile) {}; // TODO implement
    bool rename(DiskFile oldFile, std::string newName) {
        std::list<DiskFile>::iterator it;
        it = std::find(files.begin(), files.end(), oldFile);
        if (it != files.end()) {
            it->name = newName;
            return true;
        }
        return false;
    };
    void printAll() {}; // TODO implement, must print all filenames

private:
    std::list <DiskFile> files;
    float diskSize; // disk size in MB
    float freeSize; // free space in MB
};

int main(int argc, char *argv[]) {
    DiskFile df1("foo.txt", 1);
    DiskFile df2("bar.log", 20);
    Filesystem fs(50);
    fs.create(df1);
    std::cout << fs.getNumFiles() << std::endl;
    std::cout << fs.getFreeSpace() << std::endl;
    fs.create(df2);
    std::cout << fs.getNumFiles() << std::endl;
    std::cout << fs.getFreeSpace() << std::endl;
    DiskFile df3("fizz.jpg", 20);
    fs.create(df3);
    fs.rename(df3, "buzz.jpg");
    DiskFile df4("fizz.jpg", 4);
    fs.create(df4);
    fs.remove(df4);
    fs.remove(df3);
    fs.create(df3);
    fs.create(df4);
    fs.printAll();
}
