#include <stdexcept>
#include <iostream>

class HardwareDevice {
public:
    HardwareDevice(int intr=0) : interrupt(intr) {}
    void lowLevelOp() throw(std::runtime_error) { // ... something
        if(!interrupt)
            throw std::runtime_error("bad interrupt");
    }
    // other methods...
private:
    int interrupt;
};

class DeviceManager {
public:
    DeviceManager(int interrupt) : dvc(new HardwareDevice(interrupt)) {}
    ~DeviceManager() {
        delete dvc;
    }
    void use() { // ... something
        try {
            // XXX it may throw an exception
            dvc->lowLevelOp();
        } catch(std::runtime_error& e) {
            std::cerr << e.what() << std::endl;
        }
    }
    // other methods...
private:
    HardwareDevice *const dvc;
};

void test(int interrupt) {
    DeviceManager* mgr = new DeviceManager(interrupt);
    mgr->use();
    // ...
    delete mgr;
}

int main() {
    test(3);
    test(0); // will throw
}