#include <iostream>
#include <vector>

class MyFile {
public:
    explicit MyFile(std::string n) : name(n) {}
    std::string name;
    virtual void open() {}
};

class Directory : public MyFile {
public:
    explicit Directory(std::string name) : MyFile(name) {}
    Directory(const Directory& orig);
    Directory& operator=(const Directory& orig);
    std::vector<MyFile*> entries;
    void list() {
        std::cout << "Directory list:" << std::endl;
        for(auto entry : entries)
            std::cout << entry->name << std::endl;
    }
private:
    void copier(const Directory &orig);
};

Directory::Directory(const Directory &orig) : MyFile(orig.name) {
    copier(orig);
}

void Directory::copier(const Directory &orig) {
    for (auto entry : orig.entries) {
        Directory* pd = dynamic_cast<Directory*>(entry);
        MyFile* copied;
        if (pd) {
            copied = new Directory(*pd);
        } else {
            copied = new MyFile(*entry);
        }
        entries.push_back(copied);
    }
}

Directory &Directory::operator=(const Directory &orig) {
    if (this != &orig) {
        name = orig.name;
        entries.clear();
        copier(orig);
    }
    return *this;
}

int main(int argc, char *argv[]) {
    MyFile* pf = new Directory("/var/log");
    std::cout << pf->name << std::endl;
    Directory* pd = dynamic_cast<Directory*>(pf);
    if (pd) {
        MyFile* f1 = new MyFile("foo.txt");
        pd->entries.push_back(f1);
        pd->list();
    }
    else
        std::cerr << "Error";
    MyFile* pf2 = new Directory(*pd);
    Directory* pf3 = new Directory("/var/log/www");
    MyFile* f2 = new MyFile("bar.log");
    pf3->entries.push_back(f2);
    pd->entries.push_back(pf3);
    Directory* pf4 = new Directory("/tmp");
    *pf4 = *pd;
    pf4->list();
}
