#include <stdexcept>
#include <memory>
#include <iostream>

class HardwareDevice {
public:
    HardwareDevice(int intr=0) : interrupt(intr) {}
    void lowLevelOp() throw(std::runtime_error) { // ... something
        if(!interrupt)
            throw std::runtime_error("bad interrupt");
    }
    // other methods...
private:
    int interrupt;
};

class DeviceManager {
public:
    DeviceManager(int interrupt) : dvc(new HardwareDevice(interrupt)) {}
    ~DeviceManager() {
        delete dvc;
    }
    void use() { // ... something
        dvc->lowLevelOp();
    }
    // other methods...
private:
    HardwareDevice *const dvc;
};

void test(int interrupt) {
    std::unique_ptr<DeviceManager> mgr(new DeviceManager(interrupt));
    // XXX it may throw an exception
    try {
        mgr->use();
    } catch (std::runtime_error& e) {
        std::cerr << e.what() << std::endl;
    }
    // ...
}

int main() {
    test(3);
    test(0); // will throw
}