template<typename T>
class Point {
public:
    Point(T x, T y) : posX(x), posY(y) {}

    bool operator==(const T &right) {
        return ((posX == right.posX) && (posY == right.posY));
    }
    Point<T> operator+(const Point<T> &right) {
        Point<T> result(posX+right.posX, posY+right.posY);
        return result;
    }
    Point<T> operator-(const Point<T> &right) {
        Point<T> result(posX-right.posX, posY-right.posY);
        return result;
    }

    T getPosX() const {
        return posX;
    }
    void setPosX(T posX) {
        Point::posX = posX;
    }
    T getPosY() const {
        return posY;
    }
    void setPosY(T posY) {
        Point::posY = posY;
    }


private:
    T posX, posY;
};

int main() {
    Point<int> intPoint1(1, 2);
    Point<int> intPoint2(2, 3);
    Point<int> intPointC(intPoint1);
    Point<int> result = intPoint1 + intPoint2;
    Point<float> flPoint1(1.1, 2.2);
    Point<float> flPoint2(3.4, 5.6);
    Point<float> fResult = flPoint2 - flPoint1;
}
