/*
 * Character.h
 *
 */

#ifndef CHARACTER_H_
#define CHARACTER_H_

#include "Weapon.h"

class GameCharacter {
public:
    GameCharacter(int hp = 10, int a = 10);

    void move(int x, int y);

    void move(int distance);

    int getPosX() const {
        return posX;
    }

    void setPosX(int posX) {
        GameCharacter::posX = posX;
    }

    int getPosY() const {
        return posY;
    }

    void setPosY(int posY) {
        GameCharacter::posY = posY;
    }

    int getHP() const;

    void setHP(int hp);

    Weapon* getWeapon();

    void setWeapon(Weapon* weapon);

    int getArmor() const;

    void setArmor(int defense);

    bool fight(GameCharacter &enemy);
    bool isLegalFight(const GameCharacter &enemy) const;

    int receiveDamage(int points);

private:
    int HP;
    int armor;
    int posX {0};
    int posY {0};
    Weapon* weapon {nullptr};
};

#endif // CHARACTER_H_
