/*
 * Character.h
 *
 */

#ifndef CHARACTER_H_
#define CHARACTER_H_

#include "Weapon.h"

class GameCharacter {
public:
    GameCharacter();
    explicit GameCharacter(int hp, int a = 10);

    ~GameCharacter();

    GameCharacter(const GameCharacter& original);
    GameCharacter& operator=(const GameCharacter& right);

    void move(int x, int y);

    void move(int distance);

    static int l1Distance(const GameCharacter& p, const GameCharacter& q);

    int getPosX() const {
        return posX;
    }

    void setPosX(int posX) {
        GameCharacter::posX = posX;
    }

    int getPosY() const {
        return posY;
    }

    void setPosY(int posY) {
        GameCharacter::posY = posY;
    }

    int getHP() const;

    void setHP(int hp);

    Weapon* getWeapon();

    void setWeapon(Weapon* weapon);

    int getArmor() const;

    void setArmor(int defense);

    bool fight(GameCharacter &enemy);
    bool isLegalFight(const GameCharacter &enemy) const;

    int receiveDamage(int points);

private:
    int HP;
    int armor;
    int posX;
    int posY;
    Weapon* weapon;
};

#endif // CHARACTER_H_
