function [r,rm]=arma_cra(A,C,N);
% Analisi di correlazione di processi ARMA
% [r,rm]=arma_cra(A,C,N);
% r=[1 r(1) ... r(N)] e' la auto-correlazione teorica calcolata risolvendo le equazioni di Yule-Walker
% rm                  e' la auto-correlazione campionaria (correlogramma)
r=arma_ac(A,C,N);
r=[r(N+1:-1:2); r];
figure
plot([-N:N],r);
title('Funzione di auto-correlazione');
xlabel('k');
ylabel('r(k)');
M=10000;
e=randn(M,1);
y=filter(C,A,e);
rm=xcov(y,N,'unbiased');
pause;
hold on;
plot([-N:N],rm,'r');
legend('correlazione teorica','correlazione sperimentale');
