function [alpha,beta,eps]=spectral_approx(phi,omega,n)
% Approssima la densit? spettrale phi valutata nelle pulsazioni del 
% vettore omega con una funzione razionale di ordine n
% Restituisce in uscita: il vettore alpha = [ 1, ..., alpha_n] dei
% coefficienti del denominatore; il vettore beta = [ beta_0, ..., beta_n]
% dei coefficienti del numeratore; l'errore massimo eps
% dell'approssimazione razionale
N=length(phi);
q=2*cos(kron(1:n,omega));
Phi=[-diag(phi)*q,ones(N,1),q];
theta=(Phi'*Phi)\(Phi'*phi);
alpha=[1;theta(1:n)];
np=length(theta);
beta=theta(n+1:np);
eps=max(abs(phi-Phi*theta));
