    function [r,q]=spectral_fact(p);
    % Risolve la fattorizzazione spettrale polinomiale p(z)=rq(z)q(z^-1)
    % di un polinomio simmetrico p(z) determinando l'unico fattore
    % spettrale monico q(z) = 1 + ... + qn z^(-n) con radici in |z|<=1
    n=length(p)-1;
    rho=[p(n+1:-1:2) p];
    z=roots(rho);
    z=complex(z);
    [m,i]=sort(abs(z));
    z=z(i);
    z=z(1:n);
    q=poly(z);
    r=(-1)^n*rho(1)/prod(z);