function r=arma_ac(A,C,N);
% r=arma_ac(A,C,N);
% Calcola i campioni r(0), r(1), ..., r(N) della funzione di
% auto-covarianza del processo ARMA   A(z) y(t) = C(z) e(t)
% con A = [1 a1 .... an] e C=[1 c1 .... cm]
n=max(length(A),length(C));
A=[A zeros(1,n-length(A))];
C=[C zeros(1,n-length(C))];
n=n-1;
Ma=toeplitz(A,[1 zeros(1,n)])+[zeros(n,1) hankel(A(2:n+1)); zeros(1,n+1)];
Hc=hankel(C);
Ta=toeplitz(A,[1 zeros(1,n)]);
r=inv(Ma)*Hc*inv(Ta)*C';
A2=A(2:length(A));
for i=n+1:N
    r(i+1)=-A2*r(i:-1:i-n+1);
end;
