function s=arma_psd(A,C,N);
% arma_psd(A,C,N);
% Calcola la densita' spettrale, normalizzata dalla varianza del rumore bianco, 
% del processo ARMA A(z) y(t) = C(z) e(t)
% con A=[1 a1 .... an] e C=[1 c1 .... cm]
% in corrispondenza dei valori di pulsazione k pi/N per k=1,2,....,N
n=max(length(A),length(C));
A=[A zeros(1,n-length(A))];
C=[C zeros(1,n-length(C))];
n=n-1;
M=[1:N]'*[0:n];
w=[pi/N:pi/N:pi];
w0=exp(i*pi/N);
M=w0.^M;
s1=M*C';
s2=M*A';
s=abs(s1./s2).^2;
