function [s,sm]=arma_spa(A,C,N);
% Analisi spettrale di processi ARMA
% [s,sm]=arma_spa(A,C,N);
% s:  densit? spettrale teorica
% sm: densit? spettrale campionaria (periodogramma)
n=max(length(A),length(C));
A=[A zeros(1,n-length(A))];
C=[C zeros(1,n-length(C))];
n=n-1;
s=arma_psd(A,C,N);
w=[pi/N:pi/N:pi];
figure;
title('Densita spettrale di potenza');
xlabel('Pulsazione');
ylabel('PSD');
plot(w,s);
M=10000;
e=randn(M,1);
y=filter(C,A,e);
% Uso del comando spa (Spectral Analysis)
mod=spa(y,50,w);
sm=mod.SpectrumData(:);
w=mod.freq(:);
% Uso del comando etfe (Empirical Transfer Function Estimate)
%mod=etfe(y,[],N);
%sm=mod.SpectrumData(:);
%w=mod.freq(:);
% Uso del comando pwelch
%[sm,w]=pwelch(y,[],[],2*N);
%sm=sm(2:N+1);
%w=w(2:N+1);
% Uso del comando periodogram
%[sm,w]=periodogram(y,[],2*N);
pause
hold on;
plot(w,sm,'r');
legend('teorica','sperimentale');
