function draw_ellipse(m,P);
% Disegna l'ellisse di confidenza al 95%
% di equazione (x-m)'P^{-1}(x-m)=c
% con P=P'>0 (2 x 2), m (2 x 1), c=5.99 (vedi tabella chi-quadro con 2
% gradi di liberta')
% draw_ellipse(m,P,c)
c=5.99; % p=Prob(x appartiene all'ellisse)=0.95
T=chol(P)';
A=T*[0 2*pi; -2*pi 0]*inv(T);
S=ss(A,zeros(2,1),eye(2),zeros(2,1));
t=[0:0.01:1];
plot(m(1),m(2),'ro');
hold on;
[v,d]=eig(P);
x0=sqrt(d(1)*c)*v(:,1);
x=initial(S,x0,t);
x(:,1)=x(:,1)+m(1);
x(:,2)=x(:,2)+m(2);
plot(x(:,1),x(:,2),'r');