#ifndef E3_INHERITANCE_EXERCISE_KNIGHT_H
#define E3_INHERITANCE_EXERCISE_KNIGHT_H

#include <string>
#include "GameCharacter.h"

// extend GameCharacter
class Knight : public GameCharacter {
public:
    Knight(std::string n, int d, int hp = 20, int armor = 12, bool p = false);

    // override fight: dexterity > 10 perform second attack
    // if paladin then +10 damage
    int fight(GameCharacter &enemy) override;

    // override move: if dexterity > 10 allow +1 movement
    void move(int x, int y) override;

    // override base class method
    char getCharacterSymbol() const override {
        return 'K';
    }

private:
    int dexterity;
    bool paladin;
    std::string name;
};


#endif //E3_INHERITANCE_EXERCISE_KNIGHT_H
