#ifndef INVENTORY_H
#define INVENTORY_H

template <typename T>
struct ObjectPair {
   T myObject;
   bool available;

   ObjectPair() {
       available = false;
   }
};

template<typename T>
class Inventory {
public:
    explicit Inventory(int num = 5);
    virtual ~Inventory() {
        //delete[] elements;
    }
    bool setElement(int pos, const T& value);
    bool getElement(int pos, T& value) const;

    int getMaxElements() const;

    virtual void printContent() const;

protected:
    int maxElements; // max number of objects that can be stored
    ObjectPair<T>* elements; // array of stored objects
};


template<typename T>
Inventory<T>::Inventory(int num) : maxElements(num) {
    elements = new ObjectPair<T>[maxElements]; // pair constructor sets to false
}

template<typename T>
bool Inventory<T>::setElement(int pos, const T&value) {
    if (pos >= 0 && pos < maxElements && !elements[pos].available) {
        elements[pos].myObject = value;
        elements[pos].available = true;
        return true;
    }
    return false;
}

template<typename T>
bool Inventory<T>::getElement(int pos, T&value) const {
    if (pos >= 0 && pos < maxElements && elements[pos].available) {
        value = elements[pos].myObject;
        elements[pos].available = false;
        return true;
    }
    return false;
}

template<typename T>
int Inventory<T>::getMaxElements() const {
    return maxElements;
}

template<typename T>
void Inventory<T>::printContent() const {
    for (int i = 0, num = 0; i < maxElements; i++, num++) {
        T element;
        if (getElement(i, element))
            std::cout << num << ":" << element << std::endl;
    }
}

#endif //INVENTORY_H
