#include <iostream>
#include <map>
#include "Date.h"
#include "Task.h"

int main() {
    Date d1(2018, Months::Apr, 23);
    Date d2(2018, Months::May, 7);
    Date d3(2018, Months::May, 11);
    Date d4(2018, Months::Jun, 10);
    Task t1 {"Lezione Template", true, d1};
    Task t2 {"Lezione Eccezioni", true, d2};
    Task t3 {"Esercitazione Eccezioni+STL", false, d3};
    Task t4 {"Lezione coding style guidelines", false, d3};

    // @see http://en.cppreference.com/w/cpp/container/multimap/multimap
    // default comparator: http://en.cppreference.com/w/cpp/utility/functional/less
    std::multimap<Date, Task, DateComparator> agendaM;
    agendaM.insert( std::make_pair(t1.deadline, t1));
    agendaM.insert( std::make_pair(t2.deadline, t2));
    agendaM.insert( {t3.deadline, t3} ); // uniform initialization
    agendaM.insert( std::pair<Date, Task>(t4.deadline, t4));

    // @see http://en.cppreference.com/w/cpp/container/multimap/find
    // XXX compare with http://en.cppreference.com/w/cpp/algorithm/find
    auto itrM = agendaM.find(d4);
    if (itrM != std::end(agendaM))
        std::cout << itrM->second.description << std::endl;
    else
        std::cout << "Non ho niente da fare il giorno: " << d4 << std::endl;

    // @see http://en.cppreference.com/w/cpp/container/multimap/equal_range
    auto results = agendaM.equal_range(d2);
    for(auto r = results.first; r != results.second; r++) {
        std::cout << "Ricerca in data: " << d2 << " - " << r->second.description << std::endl;
    }

    std::cout << "Tutte le attivita'" << std::endl;
    for(auto task : agendaM)
        std::cout << task.first << " - " << task.second.description << std::endl;
}